/*
 * Decompiled with CFR 0.152.
 */
package at.xt.liz;

import at.xt.liz.booking.DeskBooker;
import at.xt.liz.security.RenewToken;
import lombok.Generated;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(App.class);

    public static void main(String[] args) {
        Options options = new Options();
        Option bookOption = new Option("b", "book", false, "Perform a booking");
        options.addOption(bookOption);
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        try {
            CommandLine cmd = parser.parse(options, args);
            if (args.length == 0) {
                log.info("Performing renew...");
                RenewToken.renewToken();
            } else if (cmd.hasOption("book")) {
                log.info("Performing booking...");
                DeskBooker.book();
            } else {
                log.error("Invalid arguments provided.");
                formatter.printHelp("DeskBookingApp", options);
                System.exit(1);
            }
        }
        catch (ParseException e) {
            log.error("Error parsing command-line: {}", (Object)e.getMessage());
            formatter.printHelp("DeskBookingApp", options);
            System.exit(1);
        }
    }
}

