/*
 * Decompiled with CFR 0.152.
 */
package at.xt.liz.booking;

import at.xt.liz.booking.Notifier;
import at.xt.liz.booking.api.LizBooking;
import at.xt.liz.security.model.Desk;
import at.xt.liz.security.model.Token;
import at.xt.liz.security.persistence.BookDayOverrideUtil;
import at.xt.liz.security.persistence.FileTokenUtil;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeskBooker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeskBooker.class);
    private static final int daysAhead = NumberUtils.toInt(System.getenv("DAYS_AHEAD"), 20);
    private static final String deskName = StringUtils.defaultIfBlank(System.getenv("DESK_NAME"), "OFFICE1_DESK1");
    private static final List<String> daysToBook = Arrays.asList(StringUtils.defaultIfBlank(System.getenv("DAYS_TO_BOOK"), "MONDAY,TUESDAY,WEDNESDAY,THURSDAY,FRIDAY").split(","));
    private static final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static void book() {
        LocalDate date = LocalDate.now().plusDays(daysAhead);
        Desk desk = Desk.fromString(deskName);
        DeskBooker.book(desk, date);
    }

    public static void book(Desk desk, LocalDate date) {
        log.info("Booking configuration - Days ahead: {}, Desk: {}, Days to book: {}", daysAhead, deskName, daysToBook);
        Token token = FileTokenUtil.getToken();
        Set<LocalDate> forceBook = BookDayOverrideUtil.getForceBookDays();
        Set<LocalDate> ignoreBook = BookDayOverrideUtil.getIgnoreBookDays();
        boolean isTodayForced = forceBook.contains(LocalDate.now());
        boolean isTodayIgnored = ignoreBook.contains(LocalDate.now());
        if (forceBook.stream().anyMatch(ignoreBook::contains)) {
            isTodayForced = false;
            isTodayIgnored = false;
            log.warn("Ignoring force and ignore lists, because: The set of forced days contains elements that are also supposed to be ignored. Please fix the force and ignore lists.");
        }
        if (isTodayForced) {
            String message = String.format("Book, because %s is within the list of forced days.", dtf.format(date));
            log.info(message);
            LizBooking.bookDesk(desk, date, token);
        } else if (isTodayIgnored) {
            String message = String.format("Skip booking, because %s is on the ignore list.", dtf.format(date));
            log.info(message);
        } else if (daysToBook.contains(date.getDayOfWeek().toString())) {
            LizBooking.bookDesk(desk, date, token);
        } else {
            String message = String.format("Skip booking, because %s is a %s and not in %s", dtf.format(date), date.getDayOfWeek(), daysToBook);
            log.info(message);
            Notifier.INSTANCE.notify(message);
        }
    }
}

