/*
 * Decompiled with CFR 0.152.
 */
package at.xt.liz.booking;

import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Notifier {
    INSTANCE;

    @Generated
    private static final Logger log;
    private static final String PUSHOVER_API_URL = "https://api.pushover.net/1/messages.json";
    private static final String APP_TOKEN;
    private static final String USER_KEY;
    private static final HttpClient client;

    public void notify(String message) {
        if (StringUtils.isEmpty(USER_KEY) && USER_KEY.length() < 10) {
            log.info("PUSHOVER_USER_KEY is empty or invalid - skipping PUSHOVER Notification");
            return;
        }
        this.notifyInternal(message);
    }

    private void notifyInternal(String message) {
        try {
            String postData = "token=" + URLEncoder.encode(APP_TOKEN, StandardCharsets.UTF_8) + "&user=" + URLEncoder.encode(USER_KEY, StandardCharsets.UTF_8) + "&message=" + URLEncoder.encode(message, StandardCharsets.UTF_8);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(PUSHOVER_API_URL)).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(postData)).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                log.debug("Response: {}", (Object)response.statusCode());
                log.debug("Successfully sent message to pushover API");
            } else {
                log.error("Error sending message to pushover API");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        log = LoggerFactory.getLogger(Notifier.class);
        APP_TOKEN = StringUtils.defaultIfBlank(System.getenv("PUSHOVER_APP_TOKEN"), "ajw6iqued3q5r18mhbcucho41pfr83");
        USER_KEY = System.getenv("PUSHOVER_USER_KEY");
        client = HttpClient.newHttpClient();
    }
}

