/*
 * Decompiled with CFR 0.152.
 */
package at.xt.liz.booking.api;

import at.xt.liz.booking.Notifier;
import at.xt.liz.booking.api.BookingResult;
import at.xt.liz.security.model.Desk;
import at.xt.liz.security.model.Token;
import at.xt.liz.security.persistence.FileTokenUtil;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LizBooking {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LizBooking.class);
    private static final HttpClient client = HttpClient.newHttpClient();
    private static final URI uri = URI.create("https://onltx.com/api/internal/graphql/");
    private static final String origin = "https://finder.onltx.com";
    private static final String referrer = "https://finder.onltx.com";
    private static final String userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36";
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static void bookDesk(Desk desk, LocalDate date, Token token) {
        String payloadJson = LizBooking.buildPayload(desk, date);
        HttpRequest request = LizBooking.buildTokenRequest(token, payloadJson);
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            log.info("Response Body: {}", (Object)response.body());
            if (response.statusCode() != 200) {
                log.info("Response Code: {}", (Object)String.valueOf(response.statusCode()));
                throw new RuntimeException("Unexpected response code: " + response.statusCode());
            }
            BookingResult result = FileTokenUtil.objectMapper.readValue(response.body(), BookingResult.class);
            if (Objects.nonNull(result.getErrors())) {
                Optional<String> firstError = result.getErrors().stream().filter(v -> Objects.nonNull(v.getMessage())).findFirst().map(BookingResult.GraphQLError::getMessage);
                String logError = String.format("Booking desk %s on %s failed: %s", new Object[]{desk, date, firstError});
                log.error(logError);
                Notifier.INSTANCE.notify(logError);
            } else {
                String logSuccess = String.format("Successfully booked desk %s on %s (%s)", new Object[]{desk, date, date.getDayOfWeek().toString()});
                log.info(logSuccess);
                Notifier.INSTANCE.notify(logSuccess);
            }
            log.info(result.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String buildPayload(Desk desk, LocalDate date) {
        String formattedDate = date.format(formatter);
        return "{\"operationName\":\"bookDesk\",\"variables\": {\"checkIn\": false,\"random\": false,\"areaId\": \"" + desk.getAreaId() + "\",\"deskId\": \"" + desk.getDeskId() + "\",\"start\": \"" + formattedDate + "T08:00:00+00:00\",\"end\": \"" + formattedDate + "T20:00:00+00:00\",\"language\": \"de\",\"bookingResourceId\": \"" + desk.getDeskId() + "\"},\"query\": \"mutation bookDesk($areaId: ID!, $start: DateTime!, $end: DateTime!, $deskId: ID, $comment: String, $checkIn: Boolean = false, $random: Boolean = false, $mealItems: MealItemsInput) { createBooking(booking: {areaId: $areaId, start: $start, end: $end, deskId: $deskId, comment: $comment, checkIn: $checkIn, randomBooking: $random, mealItems: $mealItems}) { start end area { areaType floor { floorLabel floorNumber floorType building { name __typename } __typename } name __typename } desk { label numberOnFloor type __typename } comment __typename } }\"}";
    }

    private static HttpRequest buildTokenRequest(Token token, String jsonPayload) {
        return HttpRequest.newBuilder().uri(uri).timeout(Duration.ofSeconds(10L)).header("accept", "*/*").header("accept-language", "de-DE,de;q=0.9,en-US;q=0.8,en;q=0.7").header("authorization", "Bearer " + token.access_token()).header("cache-control", "no-cache").header("content-type", "application/json").header("origin", "https://finder.onltx.com").header("pragma", "no-cache").header("priority", "u=1, i").header("referrer", "https://finder.onltx.com").header("sec-ch-ua", "\"Not A(Brand\";v=\"8\", \"Chromium\";v=\"132\", \"Google Chrome\";v=\"132\"").header("sec-ch-ua-mobile", "?0").header("sec-ch-ua-platform", "Windows").header("sec-fetch-dest", "empty").header("sec-fetch-mode", "cors").header("sec-fetch-site", "same-site").header("user-agent", userAgent).POST(HttpRequest.BodyPublishers.ofString(jsonPayload)).build();
    }
}

