/*
 * Decompiled with CFR 0.152.
 */
package at.xt.liz.security.api;

import at.xt.liz.booking.Notifier;
import at.xt.liz.security.model.Token;
import at.xt.liz.security.persistence.FileTokenUtil;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LizToken {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LizToken.class);
    private static final HttpClient client = HttpClient.newHttpClient();
    static boolean notifyOnSuccess = BooleanUtils.toBoolean(StringUtils.defaultIfBlank(System.getenv("NOTIFY_ON_SUCCESS"), "false"));
    private static final URI uri = URI.create("https://liz-smart-office.eu.auth0.com/oauth/token");
    private static final String clientId = System.getenv("CLIENT_ID");
    private static final String origin = "https://finder.onltx.com";
    private static final String referrer = "https://finder.onltx.com";
    private static final String userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36";

    public static Token getNewTokenFromApi(Token oldToken) throws IOException, InterruptedException {
        HttpRequest request = LizToken.buildTokenRequest(oldToken);
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            Notifier.INSTANCE.notify("Error renewing access token, status code " + response.statusCode());
            throw new RuntimeException("Unexpected response code: " + response.statusCode());
        }
        String body = response.body();
        if (notifyOnSuccess) {
            Notifier.INSTANCE.notify("New token has been successfully renewed.");
        }
        log.info("Successfully fetched new token");
        return FileTokenUtil.objectMapper.readValue(body, Token.class);
    }

    private static HttpRequest buildTokenRequest(Token oldToken) {
        String requestBody = "grant_type=refresh_token&client_id=" + clientId + "&refresh_token=" + oldToken.refresh_token();
        log.info("token request body: {}", (Object)requestBody);
        return HttpRequest.newBuilder().uri(uri).header("Accept", "application/json, text/javascript; q=0.01").header("Accept-Language", "de-DE,de;q=0.9,en-US;q=0.8,en;q=0.7").header("Cache-Control", "no-cache").header("Content-Type", "application/x-www-form-urlencoded").header("Origin", "https://finder.onltx.com").header("Pragma", "no-cache").header("Priority", "u=1, i").header("Referer", "https://finder.onltx.com").header("Sec-CH-UA", "\"Not A(Brand\";v=\"8\", \"Chromium\";v=\"132\", \"Google Chrome\";v=\"132\"").header("Sec-CH-UA-Mobile", "?0").header("Sec-CH-UA-Platform", "\"Windows\"").header("Sec-Fetch-Dest", "empty").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Site", "cross-site").header("User-Agent", userAgent).POST(HttpRequest.BodyPublishers.ofString(requestBody, StandardCharsets.UTF_8)).build();
    }
}

