/*
 * Decompiled with CFR 0.152.
 */
package at.xt.liz.security.persistence;

import at.xt.liz.security.persistence.PermissionUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookDayOverrideUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BookDayOverrideUtil.class);
    private static final String forceBookDaysTxt = StringUtils.defaultIfBlank(System.getenv("FORCE_BOOK_DAYS"), "/mnt/config/force_book_days.txt");
    private static final Path forceBookDaysPath = Paths.get(forceBookDaysTxt, new String[0]);
    private static final String ignoreBookDaysTxt = StringUtils.defaultIfBlank(System.getenv("IGNORE_BOOK_DAYS"), "/mnt/config/ignore_book_days.txt");
    private static final Path ignoreBookDaysPath = Paths.get(ignoreBookDaysTxt, new String[0]);

    public static Set<LocalDate> getForceBookDays() {
        return BookDayOverrideUtil.parseDateFile(forceBookDaysPath);
    }

    public static Set<LocalDate> getIgnoreBookDays() {
        return BookDayOverrideUtil.parseDateFile(ignoreBookDaysPath);
    }

    private static Set<LocalDate> parseDateFile(Path pathToDateFile) {
        return BookDayOverrideUtil.getDaysFromPath(pathToDateFile);
    }

    private static Set<LocalDate> getDaysFromPath(Path pathToFile) {
        try {
            return Files.readAllLines(pathToFile).stream().filter(line -> !line.trim().isEmpty() && !line.startsWith("#")).flatMap(line -> {
                if (line.contains("/")) {
                    String[] rangeStr = line.split("/");
                    LocalDate start = LocalDate.parse(rangeStr[0].trim(), DateTimeFormatter.ISO_LOCAL_DATE);
                    LocalDate end = LocalDate.parse(rangeStr[1].trim(), DateTimeFormatter.ISO_LOCAL_DATE);
                    if (end.isBefore(start)) {
                        LocalDate tmp = start;
                        start = end;
                        end = tmp;
                    }
                    return start.datesUntil(end.plusDays(1L));
                }
                return Stream.of(LocalDate.parse(line.trim(), DateTimeFormatter.ISO_LOCAL_DATE));
            }).collect(Collectors.toSet());
        }
        catch (IOException e) {
            log.warn(String.format("Did not find date file:%nPath: %s%nParent Permissions: %s%nFile Permissions: %s%nOperation: %s", pathToFile, PermissionUtil.getPermissions(pathToFile.getParent()), PermissionUtil.getPermissions(pathToFile), "reading force/ignore date list"));
            return Set.of();
        }
    }
}

