/*
 * Decompiled with CFR 0.152.
 */
package at.xt.liz.security.persistence;

import at.xt.liz.security.model.Token;
import at.xt.liz.security.persistence.PermissionUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;

public class FileTokenUtil {
    public static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String oauthJson = StringUtils.defaultIfBlank(System.getenv("OAUTH_JSON_PATH"), "/mnt/token");
    private static final Path oAuthJsonPath = Paths.get(oauthJson, new String[0]);

    public static Token getToken() {
        Token token;
        block8: {
            InputStream is = Files.newInputStream(oAuthJsonPath, new OpenOption[0]);
            try {
                token = FileTokenUtil.readTokenFomStream(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ContextedRuntimeException(e).addContextValue("path", oAuthJsonPath).addContextValue("parentPermissions", PermissionUtil.getPermissions(oAuthJsonPath.getParent())).addContextValue("filePermissions", PermissionUtil.getPermissions(oAuthJsonPath)).addContextValue("operation", "reading token file");
                }
            }
            is.close();
        }
        return token;
    }

    public static void storeNewToken(Token token) {
        try (OutputStream os = Files.newOutputStream(oAuthJsonPath, new OpenOption[0]);){
            FileTokenUtil.writeTokenToStream(token, os);
        }
        catch (IOException e) {
            throw new ContextedRuntimeException(e).addContextValue("path", oAuthJsonPath).addContextValue("parentPermissions", PermissionUtil.getPermissions(oAuthJsonPath.getParent())).addContextValue("filePermissions", PermissionUtil.getPermissions(oAuthJsonPath)).addContextValue("operation", "writing token file");
        }
    }

    private static Token readTokenFomStream(InputStream inputStream) throws IOException {
        return objectMapper.readValue(inputStream, Token.class);
    }

    private static void writeTokenToStream(Token token, OutputStream outputStream) throws IOException {
        objectMapper.writeValue(outputStream, (Object)token);
    }
}

