/*
 * Decompiled with CFR 0.152.
 */
package at.xt.liz.security.persistence;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermissions;

public class PermissionUtil {
    public static String getPermissions(Path path) {
        try {
            if (path == null || !Files.exists(path, new LinkOption[0])) {
                return "path does not exist";
            }
            return PosixFilePermissions.toString(Files.getPosixFilePermissions(path, new LinkOption[0]));
        }
        catch (UnsupportedOperationException e) {
            return "POSIX not supported on this filesystem";
        }
        catch (IOException e) {
            return "unable to read permissions: " + e.getMessage();
        }
    }
}

